from json import JSONEncoder
import json
from datetime import datetime
from TypeTranslatorToString import TypeTranslatorToString
import Registry
from datatypes.Rec1 import Rec1
from datatypes.Rec1Impl import Rec1Impl

class Rec1Encoder(JSONEncoder):
    """JSON encoder class for Rec1.
       Generated by: EASy-Producer."""

    def default(self, o):
        """Provides access to the attributes in o.
        Parameters:
            - o -- the object to serialize
        Returns:
            the attributes as dict
        """
        tmp = dict()
        for key in o.__dict__:
            k = key[1:]
            tmp[k] = o.__dict__[key]
        return tmp



class Rec1Serializer(TypeTranslatorToString):
    """JSON transport serializer for Rec1.
       Generated by: EASy-Producer."""

    def __init__(self):
        """Initializes the transformer."""
        Registry.serializers["Rec1"] = self
        Registry.types[Rec1] = "Rec1"
        Registry.serializers["Rec1Impl"] = self
        Registry.types[Rec1Impl] = "Rec1"

    def readFrom(self, data: str) -> Rec1:
        """Turns bytes into a String.
        Parameters:
            - data (str) -- the data string
        Returns:
            Rec1
                the deserialized object
        """
        result = Rec1Impl()
        jTmp = json.loads(data)
        tmp = dict()
        for key in jTmp:
            k = "_" + str(key)
            tmp[k] = jTmp[key]
        result.__dict__ = tmp
        return result

    def writeTo(self, source: Rec1) -> str:
        """Turns an object into a String.
        Parameters:
            - source (Rec1) -- the object
        Returns:
            str
                the serialized data string
        """
        return Rec1Encoder().encode(source).encode("UTF-8").decode()

    def readFromRec1(d: dict) -> Rec1:
        """Turns a dict into an object of type Rec1 for deep deserialization.
        Parameters:
            - d (dict) -- dict
        Returns:
            Rec1
                the object, may be None
        """
        if d is None:
            return None
        else:
            tmp = dict()
            result = Rec1Impl()
            for key in d:
                k = "_" + str(key)
                tmp[k] = d[key]
            result.__dict__ = tmp
            return result

    def writeToRec1(o: Rec1) -> dict:
        """Turns an object of type Rec1 into a dict for serialization.
        Parameters:
            - o (Rec1) -- the object, may be None
        Returns:
            dict
                the dict, may be None
        """
        if o is None:
            return None
        else:
            result = dict()
            for key in o.__dict__:
                k = key[1:]
                result[k] = o.__dict__[key]


Rec1Serializer()
