package iip.impl;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import de.iip_ecosphere.platform.services.environment.DefaultServiceImpl;
import de.iip_ecosphere.platform.services.environment.ParameterConfigurer;
import de.iip_ecosphere.platform.services.environment.ServiceKind;
import de.iip_ecosphere.platform.services.environment.YamlService;

import iip.interfaces.SimpleDataReceiverInterface;

/**
 * IIP-Ecosphere supporting service implementation for 'Simple Data Receiver'.
 * Generated by: EASy-Producer.
 */
public abstract class SimpleDataReceiverImpl extends DefaultServiceImpl implements SimpleDataReceiverInterface {

    private Map<String, ParameterConfigurer<?>> paramConfigurers = new HashMap<>();

    /**
     * Fallback constructor setting most fields to "empty" default values.
     *
     * @param kind the service kind
     */
    protected SimpleDataReceiverImpl(ServiceKind kind) {
        super(kind);
        registerParameterConfigurers();
    }

    /**
     * Fallback constructor setting most fields to "empty" default values.
     *
     * @param serviceId the id of the service
     * @param kind the service kind
     */
    protected SimpleDataReceiverImpl(String serviceId, ServiceKind kind) {
        super(serviceId, kind);
        registerParameterConfigurers();
    }

    /**
     * Creates a service instance from YAML information.
     *
     * @param yaml the service information as read from YAML
     */
    protected SimpleDataReceiverImpl(YamlService yaml) {
        super(yaml);
        registerParameterConfigurers();
    }

    /**
     * Creates a service instance from a service id and a YAML artifact.
     *
     * @param serviceId the id of the service
     * @param ymlFile the YML file containing the YAML artifact with the service descriptor
     */
    protected SimpleDataReceiverImpl(String serviceId, InputStream ymlFile) {
        super(serviceId, ymlFile);
        registerParameterConfigurers();
    }

    @Override
    public ParameterConfigurer<?> getParameterConfigurer(String paramName) {
        return paramConfigurers.get(paramName);
    }

    @Override
    public Set<String> getParameterNames() {
        return paramConfigurers.keySet();
    }

    /**
     * Registers the configurers.
     */
    protected void registerParameterConfigurers() {
    }

}
