from json import JSONEncoder
import json
from datetime import datetime
from TypeTranslatorToString import TypeTranslatorToString
import Registry
from datatypes.AvaMqttOutput import AvaMqttOutput
from datatypes.AvaMqttOutputImpl import AvaMqttOutputImpl

class AvaMqttOutputEncoder(JSONEncoder):
    """JSON encoder class for AvaMqttOutput.
       Generated by: EASy-Producer."""

    def default(self, o):
        """Provides access to the attributes in o.
        Parameters:
            - o -- the object to serialize
        Returns:
            the attributes as dict
        """
        tmp = dict()
        for key in o.__dict__:
            k = key[1:]
            tmp[k] = o.__dict__[key]
        return tmp



class AvaMqttOutputSerializer(TypeTranslatorToString):
    """JSON transport serializer for AvaMqttOutput.
       Generated by: EASy-Producer."""

    def __init__(self):
        """Initializes the transformer."""
        Registry.serializers["AvaMqttOutput"] = self
        Registry.types[AvaMqttOutput] = "AvaMqttOutput"
        Registry.serializers["AvaMqttOutputImpl"] = self
        Registry.types[AvaMqttOutputImpl] = "AvaMqttOutput"

    def readFrom(self, data: str) -> AvaMqttOutput:
        """Turns bytes into a String.
        Parameters:
            - data (str) -- the data string
        Returns:
            AvaMqttOutput
                the deserialized object
        """
        result = AvaMqttOutputImpl()
        jTmp = json.loads(data)
        tmp = dict()
        for key in jTmp:
            k = "_" + str(key)
            tmp[k] = jTmp[key]
        result.__dict__ = tmp
        return result

    def writeTo(self, source: AvaMqttOutput) -> str:
        """Turns an object into a String.
        Parameters:
            - source (AvaMqttOutput) -- the object
        Returns:
            str
                the serialized data string
        """
        return AvaMqttOutputEncoder().encode(source).encode("UTF-8").decode()

    def readFromAvaMqttOutput(d: dict) -> AvaMqttOutput:
        """Turns a dict into an object of type AvaMqttOutput for deep deserialization.
        Parameters:
            - d (dict) -- dict
        Returns:
            AvaMqttOutput
                the object, may be None
        """
        if d is None:
            return None
        else:
            tmp = dict()
            result = AvaMqttOutputImpl()
            for key in d:
                k = "_" + str(key)
                tmp[k] = d[key]
            result.__dict__ = tmp
            return result

    def writeToAvaMqttOutput(o: AvaMqttOutput) -> dict:
        """Turns an object of type AvaMqttOutput into a dict for serialization.
        Parameters:
            - o (AvaMqttOutput) -- the object, may be None
        Returns:
            dict
                the dict, may be None
        """
        if o is None:
            return None
        else:
            result = dict()
            for key in o.__dict__:
                k = key[1:]
                result[k] = o.__dict__[key]


AvaMqttOutputSerializer()
