package iip.serializers;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;

import de.iip_ecosphere.platform.support.json.JsonUtils;
import de.iip_ecosphere.platform.transport.serialization.Serializer;

import iip.datatypes.*;

/**
 * JSON transport serializer for SubmodelElementList.
 * Generated by: EASy-Producer.
 */
public class SubmodelElementListImplSerializer implements Serializer<SubmodelElementListImpl> {

    private static final ObjectMapper MAPPER = new ObjectMapper();

    static {
        JsonUtils.handleIipDataClasses(MAPPER);
    }

    @Override
    public SubmodelElementListImpl from(byte[] data) throws IOException {
        try {
            return MAPPER.readValue(data, SubmodelElementListImpl.class);
        } catch (JsonProcessingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public byte[] to(SubmodelElementListImpl source) throws IOException {
        try {
            return MAPPER.writeValueAsBytes(source);
        } catch (JsonProcessingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public SubmodelElementListImpl clone(SubmodelElementListImpl origin) throws IOException {
        return new SubmodelElementListImpl(origin);
    }

    @Override
    public Class<SubmodelElementListImpl> getType() {
        return SubmodelElementListImpl.class;
    }

}
