package iip.serializers;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;

import de.iip_ecosphere.platform.support.json.JsonUtils;
import de.iip_ecosphere.platform.transport.serialization.Serializer;

import iip.datatypes.*;

/**
 * JSON transport serializer for MipMqttInput.
 * Generated by: EASy-Producer.
 */
public class MipMqttInputSerializer implements Serializer<MipMqttInput> {

    private static final ObjectMapper MAPPER = new ObjectMapper();

    static {
        JsonUtils.defineOptionals(MAPPER, MipMqttInput.class, "mipfrom", "mipcommand", "mipbitstream_ai_clock", 
            "mipbitstream_ai_data1", "mipbitstream_ai_data2", "mipreader");
        JsonUtils.handleIipDataClasses(MAPPER);
    }

    @Override
    public MipMqttInput from(byte[] data) throws IOException {
        try {
            return MAPPER.readValue(data, MipMqttInputImpl.class);
        } catch (JsonProcessingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public byte[] to(MipMqttInput source) throws IOException {
        try {
            return MAPPER.writeValueAsBytes(source);
        } catch (JsonProcessingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public MipMqttInput clone(MipMqttInput origin) throws IOException {
        return new MipMqttInputImpl(origin);
    }

    @Override
    public Class<MipMqttInput> getType() {
        return MipMqttInput.class;
    }

}
