package iip.serializers;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;

import de.iip_ecosphere.platform.support.json.JsonUtils;
import de.iip_ecosphere.platform.transport.serialization.Serializer;

import iip.datatypes.*;

/**
 * JSON transport serializer for Rec1.
 * Generated by: EASy-Producer.
 */
public class Rec1Serializer implements Serializer<Rec1> {

    private static final ObjectMapper MAPPER = new ObjectMapper();

    static {
        JsonUtils.handleIipDataClasses(MAPPER);
    }

    @Override
    public Rec1 from(byte[] data) throws IOException {
        try {
            return MAPPER.readValue(data, Rec1Impl.class);
        } catch (JsonProcessingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public byte[] to(Rec1 source) throws IOException {
        try {
            return MAPPER.writeValueAsBytes(source);
        } catch (JsonProcessingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public Rec1 clone(Rec1 origin) throws IOException {
        return new Rec1Impl(origin);
    }

    @Override
    public Class<Rec1> getType() {
        return Rec1.class;
    }

}
