from AbstractService import AbstractService
import Registry
from Version import Version
from Service import ServiceState
from Service import ServiceKind
from datatypes.Rec1 import Rec1
from decimal import Decimal
from datatypes.Rec1Impl import Rec1Impl

class SimpleDataTransformerInterface(AbstractService):
    """Partially implemented service interface for "Simple Data Transformer"
       Generated by: EASy-Producer."""

    ingestor = None

    def __init__(self):
        """Initializes the service."""
        super().__init__("SimpleTransformer", "Simple Data Transformer", Version("0.1.0"), "", True, ServiceKind.TRANSFORMATION_SERVICE)
        Registry.services['SimpleTransformer'] = self
        self.registerMethods()

    def attachIngestor(self, ingestor):
        """Called by ServiceEnvironment to attach an individual type-generic ingestor, i.e., a function 
           that allows to asynchronously ingest result data back into stream processing. The ingestor
           cares for the type and the target stream.
        Parameters:
            - ingestor -- the ingestor function
        """
        self.ingestor = ingestor

    def ingest(self, data):
        """Ingests result data asynchronously into stream processing. Target stream and data type are 
           handled by the ingestor.
        Parameters:
            - data -- the data to ingest; if the type is unknown/no type translator registered, nothing will happen
        """
        if self.ingestor is not None:
            self.ingestor(data)

    def setState(self, state: ServiceState):
        """Changes the state. [R133c]
        Parameters:
            - state (ServiceState) -- the new state
        """
        super().setState(state)
        if state==ServiceState.STARTING:
            self.start()
        if state==ServiceState.STOPPING:
            self.stop()

    def start(self):
        """Called when the service shall start."""
        pass

    def stop(self):
        """Called when the service shall stop."""
        pass

    def processRec1(self, data: Rec1):
        """Asynchronous data processing method. Use self.ingest(data) to pass the result back to the data stream. Possible output types: Rec1Impl
        Parameters:
            - data (Rec1) -- the data to process
        """
        raise NotImplementedError

    def registerMethods(self):
        Registry.asyncTransformers['SimpleTransformer_Rec1'] = self.processRec1

    def createRec1(self) -> Rec1:
        """Creates an actual instance of the output type Rec1.
        Returns:
            Rec1
                the instance
        """
        return AbstractService.createDataInstance("Rec1", lambda : Rec1Impl())


