/*
 * Decompiled with CFR 0.152.
 */
package iip.serializers;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.iip_ecosphere.platform.support.json.JsonUtils;
import de.iip_ecosphere.platform.transport.serialization.Serializer;
import iip.datatypes.MipMqttInput;
import iip.datatypes.MipMqttInputImpl;
import java.io.IOException;

public class MipMqttInputSerializer
implements Serializer<MipMqttInput> {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public MipMqttInput from(byte[] data) throws IOException {
        try {
            return (MipMqttInput)MAPPER.readValue(data, MipMqttInputImpl.class);
        }
        catch (JsonProcessingException e) {
            throw new IOException(e);
        }
    }

    public byte[] to(MipMqttInput source) throws IOException {
        try {
            return MAPPER.writeValueAsBytes((Object)source);
        }
        catch (JsonProcessingException e) {
            throw new IOException(e);
        }
    }

    public MipMqttInput clone(MipMqttInput origin) throws IOException {
        return new MipMqttInputImpl(origin);
    }

    public Class<MipMqttInput> getType() {
        return MipMqttInput.class;
    }

    static {
        JsonUtils.defineOptionals((ObjectMapper)MAPPER, MipMqttInput.class, (String[])new String[]{"mipfrom", "mipcommand", "mipbitstream_ai_clock", "mipbitstream_ai_data1", "mipbitstream_ai_data2", "mipreader"});
        JsonUtils.handleIipDataClasses((ObjectMapper)MAPPER);
    }
}

