/*
 * Decompiled with CFR 0.152.
 */
package iip.serializers;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.iip_ecosphere.platform.support.json.JsonUtils;
import de.iip_ecosphere.platform.transport.serialization.Serializer;
import iip.datatypes.MipMqttOutput;
import iip.datatypes.MipMqttOutputImpl;
import java.io.IOException;

public class MipMqttOutputSerializer
implements Serializer<MipMqttOutput> {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public MipMqttOutput from(byte[] data) throws IOException {
        try {
            return (MipMqttOutput)MAPPER.readValue(data, MipMqttOutputImpl.class);
        }
        catch (JsonProcessingException e) {
            throw new IOException(e);
        }
    }

    public byte[] to(MipMqttOutput source) throws IOException {
        try {
            return MAPPER.writeValueAsBytes((Object)source);
        }
        catch (JsonProcessingException e) {
            throw new IOException(e);
        }
    }

    public MipMqttOutput clone(MipMqttOutput origin) throws IOException {
        return new MipMqttOutputImpl(origin);
    }

    public Class<MipMqttOutput> getType() {
        return MipMqttOutput.class;
    }

    static {
        JsonUtils.defineOptionals((ObjectMapper)MAPPER, MipMqttOutput.class, (String[])new String[]{"mipraw_signal_clock", "mipraw_signal_data1", "mipraw_signal_data2"});
        JsonUtils.handleIipDataClasses((ObjectMapper)MAPPER);
    }
}

