package iip.datatypes;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

import de.iip_ecosphere.platform.support.StringUtils;
import de.iip_ecosphere.platform.support.iip_aas.ConfiguredName;

import iip.datatypes.KRec13Impl;
import iip.datatypes.KRec13Refined;

/**
 * Implementation of the application data type KRec13Refined.
 * Generated by: EASy-Producer.
 */
@ConfiguredName("KRec13Refined")
public class KRec13RefinedImpl extends KRec13Impl implements KRec13Refined {

    @JsonProperty("intField2")
    @ConfiguredName("intField2")
    private int intField2;
    @JsonProperty("stringField2")
    @ConfiguredName("stringField2")
    private String stringField2;

    /**
     * Default constructor. Fields are pre-allocated with default Java values.
     */
    public KRec13RefinedImpl() {
    }

    /**
     * Copy constructor.
     *
     * @param from the instance to copy the values from
     */
    public KRec13RefinedImpl(KRec13Refined from) {
        super(from);
        this.intField2 = from.getIntField2();
        this.stringField2 = from.getStringField2();
    }

    @Override
    @JsonIgnore
    public int getIntField2() {
        return intField2;
    }

    @Override
    @JsonIgnore
    public void setIntField2(int value) {
        this.intField2 = value;
    }

    @Override
    @JsonIgnore
    public String getStringField2() {
        return stringField2;
    }

    @Override
    @JsonIgnore
    public void setStringField2(String value) {
        this.stringField2 = value;
    }

    @Override
    public int hashCode() {
        int hc = 0;
        hc += Integer.hashCode(getIntField2());
        hc += getStringField2() != null ? getStringField2().hashCode() : 0;
        return hc;
    }

    @Override
    public boolean equals(Object other) {
        boolean eq;
        if (other instanceof KRec13Refined) {
            KRec13Refined oth = (KRec13Refined) other;
            eq = true;
            eq &= getIntField2() == oth.getIntField2();
            eq &= getStringField2() != null ? getStringField2().equals(oth.getStringField2()) : true;
        } else {
            eq = false;
        }
        return eq;
    }

    @Override
    public String toString() {
        return StringUtils.toStringShortStyle(this);
    }

}
