package iip.datatypes;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

import de.iip_ecosphere.platform.support.StringUtils;
import de.iip_ecosphere.platform.support.iip_aas.ConfiguredName;

import iip.datatypes.TurnstilePlcOutput;

/**
 * Implementation of the application data type TurnstilePlcOutput.
 * Generated by: EASy-Producer.
 */
@ConfiguredName("TurnstilePlcOutput")
public class TurnstilePlcOutputImpl implements TurnstilePlcOutput {

    @JsonProperty("insertCoin")
    @ConfiguredName("insertCoin")
    private boolean insertCoin;
    @JsonProperty("push")
    @ConfiguredName("push")
    private boolean push;
    @JsonProperty("money")
    @ConfiguredName("money")
    private double money;
    @JsonProperty("ready")
    @ConfiguredName("ready")
    private boolean ready;

    /**
     * Default constructor. Fields are pre-allocated with default Java values.
     */
    public TurnstilePlcOutputImpl() {
    }

    /**
     * Copy constructor.
     *
     * @param from the instance to copy the values from
     */
    public TurnstilePlcOutputImpl(TurnstilePlcOutput from) {
        this.insertCoin = from.getInsertCoin();
        this.push = from.getPush();
        this.money = from.getMoney();
        this.ready = from.getReady();
    }

    @Override
    @JsonIgnore
    public boolean getInsertCoin() {
        return insertCoin;
    }

    @Override
    @JsonIgnore
    public void setInsertCoin(boolean value) {
        this.insertCoin = value;
    }

    @Override
    @JsonIgnore
    public boolean getPush() {
        return push;
    }

    @Override
    @JsonIgnore
    public void setPush(boolean value) {
        this.push = value;
    }

    @Override
    @JsonIgnore
    public double getMoney() {
        return money;
    }

    @Override
    @JsonIgnore
    public void setMoney(double value) {
        this.money = value;
    }

    @Override
    @JsonIgnore
    public boolean getReady() {
        return ready;
    }

    @Override
    @JsonIgnore
    public void setReady(boolean value) {
        this.ready = value;
    }

    @Override
    public int hashCode() {
        int hc = 0;
        hc += Boolean.hashCode(getInsertCoin());
        hc += Boolean.hashCode(getPush());
        hc += Double.hashCode(getMoney());
        hc += Boolean.hashCode(getReady());
        return hc;
    }

    @Override
    public boolean equals(Object other) {
        boolean eq;
        if (other instanceof TurnstilePlcOutput) {
            TurnstilePlcOutput oth = (TurnstilePlcOutput) other;
            eq = true;
            eq &= getInsertCoin() == oth.getInsertCoin();
            eq &= getPush() == oth.getPush();
            eq &= getMoney() == oth.getMoney();
            eq &= getReady() == oth.getReady();
        } else {
            eq = false;
        }
        return eq;
    }

    @Override
    public String toString() {
        return StringUtils.toStringShortStyle(this);
    }

}
