package iip.serializers;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;

import de.iip_ecosphere.platform.support.json.JsonUtils;
import de.iip_ecosphere.platform.transport.serialization.Serializer;

import iip.datatypes.*;

/**
 * JSON transport serializer for KRec13Anon.
 * Generated by: EASy-Producer.
 */
public class KRec13AnonImplSerializer implements Serializer<KRec13AnonImpl> {

    private static final ObjectMapper MAPPER = new ObjectMapper();

    static {
        JsonUtils.handleIipDataClasses(MAPPER);
    }

    @Override
    public KRec13AnonImpl from(byte[] data) throws IOException {
        try {
            return MAPPER.readValue(data, KRec13AnonImpl.class);
        } catch (JsonProcessingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public byte[] to(KRec13AnonImpl source) throws IOException {
        try {
            return MAPPER.writeValueAsBytes(source);
        } catch (JsonProcessingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public KRec13AnonImpl clone(KRec13AnonImpl origin) throws IOException {
        return new KRec13AnonImpl(origin);
    }

    @Override
    public Class<KRec13AnonImpl> getType() {
        return KRec13AnonImpl.class;
    }

}
