package iip.serializers;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;

import de.iip_ecosphere.platform.support.json.JsonUtils;
import de.iip_ecosphere.platform.transport.serialization.Serializer;

import iip.datatypes.*;

/**
 * JSON transport serializer for KRec13Refined.
 * Generated by: EASy-Producer.
 */
public class KRec13RefinedSerializer implements Serializer<KRec13Refined> {

    private static final ObjectMapper MAPPER = new ObjectMapper();

    static {
        JsonUtils.handleIipDataClasses(MAPPER);
    }

    @Override
    public KRec13Refined from(byte[] data) throws IOException {
        try {
            return MAPPER.readValue(data, KRec13RefinedImpl.class);
        } catch (JsonProcessingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public byte[] to(KRec13Refined source) throws IOException {
        try {
            return MAPPER.writeValueAsBytes(source);
        } catch (JsonProcessingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public KRec13Refined clone(KRec13Refined origin) throws IOException {
        return new KRec13RefinedImpl(origin);
    }

    @Override
    public Class<KRec13Refined> getType() {
        return KRec13Refined.class;
    }

}
