package iip.serializers;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;

import de.iip_ecosphere.platform.support.json.JsonUtils;
import de.iip_ecosphere.platform.transport.serialization.Serializer;

import iip.datatypes.*;

/**
 * JSON transport serializer for TurnstilePlcOutput.
 * Generated by: EASy-Producer.
 */
public class TurnstilePlcOutputSerializer implements Serializer<TurnstilePlcOutput> {

    private static final ObjectMapper MAPPER = new ObjectMapper();

    static {
        JsonUtils.handleIipDataClasses(MAPPER);
    }

    @Override
    public TurnstilePlcOutput from(byte[] data) throws IOException {
        try {
            return MAPPER.readValue(data, TurnstilePlcOutputImpl.class);
        } catch (JsonProcessingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public byte[] to(TurnstilePlcOutput source) throws IOException {
        try {
            return MAPPER.writeValueAsBytes(source);
        } catch (JsonProcessingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public TurnstilePlcOutput clone(TurnstilePlcOutput origin) throws IOException {
        return new TurnstilePlcOutputImpl(origin);
    }

    @Override
    public Class<TurnstilePlcOutput> getType() {
        return TurnstilePlcOutput.class;
    }

}
