from AbstractService import AbstractService
import Registry
from Version import Version
from Service import ServiceState
from Service import ServiceKind
from datatypes.KRec13Anon import KRec13Anon
from decimal import Decimal
from datatypes.KRec13AnonImpl import KRec13AnonImpl

class KodexPythonServiceInterface(AbstractService):
    """Partially implemented service interface for "Kodex Python Service"
       Generated by: EASy-Producer."""

    ingestor = None
    param_passThrough = False
    param_sParam = "abc"

    def __init__(self):
        """Initializes the service."""
        super().__init__("KodexPythonService", "Kodex Python Service", Version("0.1.0"), "", True, ServiceKind.TRANSFORMATION_SERVICE)
        Registry.services['KodexPythonService'] = self
        self.registerMethods()

    def attachIngestor(self, ingestor):
        """Called by ServiceEnvironment to attach an individual type-generic ingestor, i.e., a function 
           that allows to asynchronously ingest result data back into stream processing. The ingestor
           cares for the type and the target stream.
        Parameters:
            - ingestor -- the ingestor function
        """
        self.ingestor = ingestor

    def ingest(self, data):
        """Ingests result data asynchronously into stream processing. Target stream and data type are 
           handled by the ingestor.
        Parameters:
            - data -- the data to ingest; if the type is unknown/no type translator registered, nothing will happen
        """
        if self.ingestor is not None:
            self.ingestor(data)

    def setState(self, state: ServiceState):
        """Changes the state. [R133c]
        Parameters:
            - state (ServiceState) -- the new state
        """
        super().setState(state)
        if state==ServiceState.STARTING:
            self.start()
        if state==ServiceState.STOPPING:
            self.stop()

    def start(self):
        """Called when the service shall start."""
        pass

    def stop(self):
        """Called when the service shall stop."""
        pass

    def notifyReconfigured(self, values: dict):
        """Called to inform the implementing class that a parameter reconfiguration happened.
        Parameters:
            - values (dict) -- the new param names/values
        """
        pass

    def reconfigure(self, values: dict):
        """Called by ServiceEnvironment to initialize service parameters or to reconfigure them at runtime.
        Parameters:
            - values (dict) -- the new param names/values
        """
        if "passThrough" in values:
            self.param_passThrough = str(values["passThrough"]).lower() == "true"
        if "sParam" in values:
            self.param_sParam = values["sParam"]
        self.notifyReconfigured(values)

    def getPassThrough(self):
        """Returns the value of parameter passThrough. May change at runtime upon reconfiguration.
        Returns:
            the value of the parameter
        """
        return self.param_passThrough

    def getSParam(self):
        """Returns the value of parameter sParam. May change at runtime upon reconfiguration.
        Returns:
            the value of the parameter
        """
        return self.param_sParam

    def transformKRec13Anon(self, data: KRec13Anon) -> KRec13Anon:
        """Synchronous data processing/transformation method.
        Parameters:
            - data (KRec13Anon) -- the data to process
        Returns:
            KRec13Anon
                the processed data (not None)
        """
        raise NotImplementedError

    def registerMethods(self):
        Registry.syncTransformers['KodexPythonService_KRec13Anon'] = self.transformKRec13Anon

    def createKRec13Anon(self) -> KRec13Anon:
        """Creates an actual instance of the output type KRec13Anon.
        Returns:
            KRec13Anon
                the instance
        """
        return AbstractService.createDataInstance("KRec13Anon", lambda : KRec13AnonImpl())


