from json import JSONEncoder
import json
from datetime import datetime
from TypeTranslatorToString import TypeTranslatorToString
import Registry
from datatypes.KRec13Anon import KRec13Anon
from datatypes.KRec13AnonImpl import KRec13AnonImpl

class KRec13AnonEncoder(JSONEncoder):
    """JSON encoder class for KRec13Anon.
       Generated by: EASy-Producer."""

    def default(self, o):
        """Provides access to the attributes in o.
        Parameters:
            - o -- the object to serialize
        Returns:
            the attributes as dict
        """
        tmp = dict()
        for key in o.__dict__:
            k = key[1:]
            tmp[k] = o.__dict__[key]
        return tmp



class KRec13AnonSerializer(TypeTranslatorToString):
    """JSON transport serializer for KRec13Anon.
       Generated by: EASy-Producer."""

    def __init__(self):
        """Initializes the transformer."""
        Registry.serializers["KRec13Anon"] = self
        Registry.types[KRec13Anon] = "KRec13Anon"
        Registry.serializers["KRec13AnonImpl"] = self
        Registry.types[KRec13AnonImpl] = "KRec13Anon"

    def readFrom(self, data: str) -> KRec13Anon:
        """Turns bytes into a String.
        Parameters:
            - data (str) -- the data string
        Returns:
            KRec13Anon
                the deserialized object
        """
        result = KRec13AnonImpl()
        jTmp = json.loads(data)
        tmp = dict()
        for key in jTmp:
            k = "_" + str(key)
            tmp[k] = jTmp[key]
        result.__dict__ = tmp
        return result

    def writeTo(self, source: KRec13Anon) -> str:
        """Turns an object into a String.
        Parameters:
            - source (KRec13Anon) -- the object
        Returns:
            str
                the serialized data string
        """
        return KRec13AnonEncoder().encode(source).encode("UTF-8").decode()

    def readFromKRec13Anon(d: dict) -> KRec13Anon:
        """Turns a dict into an object of type KRec13Anon for deep deserialization.
        Parameters:
            - d (dict) -- dict
        Returns:
            KRec13Anon
                the object, may be None
        """
        if d is None:
            return None
        else:
            tmp = dict()
            result = KRec13AnonImpl()
            for key in d:
                k = "_" + str(key)
                tmp[k] = d[key]
            result.__dict__ = tmp
            return result

    def writeToKRec13Anon(o: KRec13Anon) -> dict:
        """Turns an object of type KRec13Anon into a dict for serialization.
        Parameters:
            - o (KRec13Anon) -- the object, may be None
        Returns:
            dict
                the dict, may be None
        """
        if o is None:
            return None
        else:
            result = dict()
            for key in o.__dict__:
                k = key[1:]
                result[k] = o.__dict__[key]


KRec13AnonSerializer()
