from json import JSONEncoder
import json
from datetime import datetime
from TypeTranslatorToString import TypeTranslatorToString
import Registry
from datatypes.MipMqttInput import MipMqttInput
from datatypes.MipMqttInputImpl import MipMqttInputImpl

class MipMqttInputEncoder(JSONEncoder):
    """JSON encoder class for MipMqttInput.
       Generated by: EASy-Producer."""

    def default(self, o):
        """Provides access to the attributes in o.
        Parameters:
            - o -- the object to serialize
        Returns:
            the attributes as dict
        """
        tmp = dict()
        for key in o.__dict__:
            k = key[1:]
            tmp[k] = o.__dict__[key]
        return tmp



class MipMqttInputSerializer(TypeTranslatorToString):
    """JSON transport serializer for MipMqttInput.
       Generated by: EASy-Producer."""

    def __init__(self):
        """Initializes the transformer."""
        Registry.serializers["MipMqttInput"] = self
        Registry.types[MipMqttInput] = "MipMqttInput"
        Registry.serializers["MipMqttInputImpl"] = self
        Registry.types[MipMqttInputImpl] = "MipMqttInput"

    def readFrom(self, data: str) -> MipMqttInput:
        """Turns bytes into a String.
        Parameters:
            - data (str) -- the data string
        Returns:
            MipMqttInput
                the deserialized object
        """
        result = MipMqttInputImpl()
        jTmp = json.loads(data)
        tmp = dict()
        for key in jTmp:
            k = "_" + str(key)
            tmp[k] = jTmp[key]
        result.__dict__ = tmp
        return result

    def writeTo(self, source: MipMqttInput) -> str:
        """Turns an object into a String.
        Parameters:
            - source (MipMqttInput) -- the object
        Returns:
            str
                the serialized data string
        """
        return MipMqttInputEncoder().encode(source).encode("UTF-8").decode()

    def readFromMipMqttInput(d: dict) -> MipMqttInput:
        """Turns a dict into an object of type MipMqttInput for deep deserialization.
        Parameters:
            - d (dict) -- dict
        Returns:
            MipMqttInput
                the object, may be None
        """
        if d is None:
            return None
        else:
            tmp = dict()
            result = MipMqttInputImpl()
            for key in d:
                k = "_" + str(key)
                tmp[k] = d[key]
            result.__dict__ = tmp
            return result

    def writeToMipMqttInput(o: MipMqttInput) -> dict:
        """Turns an object of type MipMqttInput into a dict for serialization.
        Parameters:
            - o (MipMqttInput) -- the object, may be None
        Returns:
            dict
                the dict, may be None
        """
        if o is None:
            return None
        else:
            result = dict()
            for key in o.__dict__:
                k = key[1:]
                result[k] = o.__dict__[key]


MipMqttInputSerializer()
