package iip.serializers;

import java.io.IOException;

import de.iip_ecosphere.platform.support.json.Json;
import de.iip_ecosphere.platform.transport.serialization.Serializer;

import iip.datatypes.*;

/**
 * JSON transport serializer for KRec13.
 * Generated by: EASy-Producer.
 */
public class KRec13Serializer implements Serializer<KRec13> {

    private static final Json MAPPER = Json.createInstance4All();

    static {
        MAPPER.handleIipDataClasses();
    }

    @Override
    public KRec13 from(byte[] data) throws IOException {
        return MAPPER.readValue(data, KRec13Impl.class);
    }

    @Override
    public byte[] to(KRec13 source) throws IOException {
        return MAPPER.writeValueAsBytes(source);
    }

    @Override
    public KRec13 clone(KRec13 origin) throws IOException {
        return new KRec13Impl(origin);
    }

    @Override
    public Class<KRec13> getType() {
        return KRec13.class;
    }

}
