package iip.serializers;

import java.io.IOException;

import de.iip_ecosphere.platform.support.json.Json;
import de.iip_ecosphere.platform.transport.serialization.Serializer;

import iip.datatypes.*;

/**
 * JSON transport serializer for MipMqttOutput.
 * Generated by: EASy-Producer.
 */
public class MipMqttOutputSerializer implements Serializer<MipMqttOutput> {

    private static final Json MAPPER = Json.createInstance4All();

    static {
        MAPPER.defineOptionals(MipMqttOutput.class, "mipraw_signal_clock", "mipraw_signal_data1", "mipraw_signal_data2"
            );
        MAPPER.handleIipDataClasses();
    }

    @Override
    public MipMqttOutput from(byte[] data) throws IOException {
        return MAPPER.readValue(data, MipMqttOutputImpl.class);
    }

    @Override
    public byte[] to(MipMqttOutput source) throws IOException {
        return MAPPER.writeValueAsBytes(source);
    }

    @Override
    public MipMqttOutput clone(MipMqttOutput origin) throws IOException {
        return new MipMqttOutputImpl(origin);
    }

    @Override
    public Class<MipMqttOutput> getType() {
        return MipMqttOutput.class;
    }

}
