from json import JSONEncoder
import json
from datetime import datetime
from TypeTranslatorToString import TypeTranslatorToString
import Registry
from datatypes.KRec13 import KRec13
from datatypes.KRec13Impl import KRec13Impl

class KRec13Encoder(JSONEncoder):
    """JSON encoder class for KRec13.
       Generated by: EASy-Producer."""

    def default(self, o):
        """Provides access to the attributes in o.
        Parameters:
            - o -- the object to serialize
        Returns:
            the attributes as dict
        """
        tmp = dict()
        for key in o.__dict__:
            k = key[1:]
            tmp[k] = o.__dict__[key]
        return tmp



class KRec13Serializer(TypeTranslatorToString):
    """JSON transport serializer for KRec13.
       Generated by: EASy-Producer."""

    def __init__(self):
        """Initializes the transformer."""
        Registry.serializers["KRec13"] = self
        Registry.types[KRec13] = "KRec13"
        Registry.serializers["KRec13Impl"] = self
        Registry.types[KRec13Impl] = "KRec13"

    def readFrom(self, data: str) -> KRec13:
        """Turns bytes into a String.
        Parameters:
            - data (str) -- the data string
        Returns:
            KRec13
                the deserialized object
        """
        result = KRec13Impl()
        jTmp = json.loads(data)
        tmp = dict()
        for key in jTmp:
            k = "_" + str(key)
            tmp[k] = jTmp[key]
        result.__dict__ = tmp
        return result

    def writeTo(self, source: KRec13) -> str:
        """Turns an object into a String.
        Parameters:
            - source (KRec13) -- the object
        Returns:
            str
                the serialized data string
        """
        return KRec13Encoder().encode(source).encode("UTF-8").decode()

    def readFromKRec13(d: dict) -> KRec13:
        """Turns a dict into an object of type KRec13 for deep deserialization.
        Parameters:
            - d (dict) -- dict
        Returns:
            KRec13
                the object, may be None
        """
        if d is None:
            return None
        else:
            tmp = dict()
            result = KRec13Impl()
            for key in d:
                k = "_" + str(key)
                tmp[k] = d[key]
            result.__dict__ = tmp
            return result

    def writeToKRec13(o: KRec13) -> dict:
        """Turns an object of type KRec13 into a dict for serialization.
        Parameters:
            - o (KRec13) -- the object, may be None
        Returns:
            dict
                the dict, may be None
        """
        if o is None:
            return None
        else:
            result = dict()
            for key in o.__dict__:
                k = key[1:]
                result[k] = o.__dict__[key]


KRec13Serializer()
