from json import JSONEncoder
import json
from datetime import datetime
from TypeTranslatorToString import TypeTranslatorToString
import Registry
from datatypes.TurnstilePlcOutput import TurnstilePlcOutput
from datatypes.TurnstilePlcOutputImpl import TurnstilePlcOutputImpl

class TurnstilePlcOutputEncoder(JSONEncoder):
    """JSON encoder class for TurnstilePlcOutput.
       Generated by: EASy-Producer."""

    def default(self, o):
        """Provides access to the attributes in o.
        Parameters:
            - o -- the object to serialize
        Returns:
            the attributes as dict
        """
        tmp = dict()
        for key in o.__dict__:
            k = key[1:]
            tmp[k] = o.__dict__[key]
        return tmp



class TurnstilePlcOutputSerializer(TypeTranslatorToString):
    """JSON transport serializer for TurnstilePlcOutput.
       Generated by: EASy-Producer."""

    def __init__(self):
        """Initializes the transformer."""
        Registry.serializers["TurnstilePlcOutput"] = self
        Registry.types[TurnstilePlcOutput] = "TurnstilePlcOutput"
        Registry.serializers["TurnstilePlcOutputImpl"] = self
        Registry.types[TurnstilePlcOutputImpl] = "TurnstilePlcOutput"

    def readFrom(self, data: str) -> TurnstilePlcOutput:
        """Turns bytes into a String.
        Parameters:
            - data (str) -- the data string
        Returns:
            TurnstilePlcOutput
                the deserialized object
        """
        result = TurnstilePlcOutputImpl()
        jTmp = json.loads(data)
        tmp = dict()
        for key in jTmp:
            k = "_" + str(key)
            tmp[k] = jTmp[key]
        result.__dict__ = tmp
        return result

    def writeTo(self, source: TurnstilePlcOutput) -> str:
        """Turns an object into a String.
        Parameters:
            - source (TurnstilePlcOutput) -- the object
        Returns:
            str
                the serialized data string
        """
        return TurnstilePlcOutputEncoder().encode(source).encode("UTF-8").decode()

    def readFromTurnstilePlcOutput(d: dict) -> TurnstilePlcOutput:
        """Turns a dict into an object of type TurnstilePlcOutput for deep deserialization.
        Parameters:
            - d (dict) -- dict
        Returns:
            TurnstilePlcOutput
                the object, may be None
        """
        if d is None:
            return None
        else:
            tmp = dict()
            result = TurnstilePlcOutputImpl()
            for key in d:
                k = "_" + str(key)
                tmp[k] = d[key]
            result.__dict__ = tmp
            return result

    def writeToTurnstilePlcOutput(o: TurnstilePlcOutput) -> dict:
        """Turns an object of type TurnstilePlcOutput into a dict for serialization.
        Parameters:
            - o (TurnstilePlcOutput) -- the object, may be None
        Returns:
            dict
                the dict, may be None
        """
        if o is None:
            return None
        else:
            result = dict()
            for key in o.__dict__:
                k = key[1:]
                result[k] = o.__dict__[key]


TurnstilePlcOutputSerializer()
