package iip.interfaces;

import de.iip_ecosphere.platform.services.environment.Service;

import iip.datatypes.KRec13Anon;
import iip.datatypes.TurnstilePlcOutput;

/**
 * IIP-Ecosphere service interface for 'StateService'.
 * Generated by: EASy-Producer.
 */
public interface StateServiceInterface extends Service {

    public static final String SERVICE_ID = "StateService";

    /**
     * Processes a data item of type "TurnstilePlcOutput" asynchronously. Use the respective ingestor for the return type
     * to pass back the result of processing.
     *
     * @param data the data item to be processed
     */
    public void processTurnstilePlcOutput(TurnstilePlcOutput data);

    /**
     * Processes a data item of type "KRec13Anon" asynchronously. Use the respective ingestor for the return type to pass
     * back the result of processing.
     *
     * @param data the data item to be processed
     */
    public void processKRec13Anon(KRec13Anon data);

}
