package iip.serializers;

import java.io.IOException;

import de.iip_ecosphere.platform.support.json.Json;
import de.iip_ecosphere.platform.transport.serialization.Serializer;

import iip.datatypes.*;

/**
 * JSON transport serializer for TurnstilePlcOutput.
 * Generated by: EASy-Producer.
 */
public class TurnstilePlcOutputSerializer implements Serializer<TurnstilePlcOutput> {

    private static final Json MAPPER = Json.createInstance4All();

    static {
        MAPPER.handleIipDataClasses();
    }

    @Override
    public TurnstilePlcOutput from(byte[] data) throws IOException {
        return MAPPER.readValue(data, TurnstilePlcOutputImpl.class);
    }

    @Override
    public byte[] to(TurnstilePlcOutput source) throws IOException {
        return MAPPER.writeValueAsBytes(source);
    }

    @Override
    public TurnstilePlcOutput clone(TurnstilePlcOutput origin) throws IOException {
        return new TurnstilePlcOutputImpl(origin);
    }

    @Override
    public Class<TurnstilePlcOutput> getType() {
        return TurnstilePlcOutput.class;
    }

}
