package iip.serializers;

import java.io.IOException;

import de.iip_ecosphere.platform.support.json.Json;
import de.iip_ecosphere.platform.transport.serialization.Serializer;

import iip.datatypes.*;

/**
 * JSON transport serializer for AvaMqttOutput.
 * Generated by: EASy-Producer.
 */
public class AvaMqttOutputSerializer implements Serializer<AvaMqttOutput> {

    private static final Json MAPPER = Json.createInstance4All();

    static {
        MAPPER.handleIipDataClasses();
    }

    @Override
    public AvaMqttOutput from(byte[] data) throws IOException {
        return MAPPER.readValue(data, AvaMqttOutputImpl.class);
    }

    @Override
    public byte[] to(AvaMqttOutput source) throws IOException {
        return MAPPER.writeValueAsBytes(source);
    }

    @Override
    public AvaMqttOutput clone(AvaMqttOutput origin) throws IOException {
        return new AvaMqttOutputImpl(origin);
    }

    @Override
    public Class<AvaMqttOutput> getType() {
        return AvaMqttOutput.class;
    }

}
