package iip.serializers;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;

import de.iip_ecosphere.platform.support.json.JsonUtils;
import de.iip_ecosphere.platform.transport.serialization.Serializer;

import iip.datatypes.*;

/**
 * JSON transport serializer for MipMqttOutput.
 * Generated by: EASy-Producer.
 */
public class MipMqttOutputImplSerializer implements Serializer<MipMqttOutputImpl> {

    private static final ObjectMapper MAPPER = new ObjectMapper();

    static {
        JsonUtils.defineOptionals(MAPPER, MipMqttOutputImpl.class, "mipraw_signal_clock", "mipraw_signal_data1", 
            "mipraw_signal_data2");
        JsonUtils.handleIipDataClasses(MAPPER);
    }

    @Override
    public MipMqttOutputImpl from(byte[] data) throws IOException {
        try {
            return MAPPER.readValue(data, MipMqttOutputImpl.class);
        } catch (JsonProcessingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public byte[] to(MipMqttOutputImpl source) throws IOException {
        try {
            return MAPPER.writeValueAsBytes(source);
        } catch (JsonProcessingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public MipMqttOutputImpl clone(MipMqttOutputImpl origin) throws IOException {
        return new MipMqttOutputImpl(origin);
    }

    @Override
    public Class<MipMqttOutputImpl> getType() {
        return MipMqttOutputImpl.class;
    }

}
