/*
 * Decompiled with CFR 0.152.
 */
package iip.impl;

import de.iip_ecosphere.platform.services.environment.DataIngestor;
import de.iip_ecosphere.platform.services.environment.DefaultServiceImpl;
import de.iip_ecosphere.platform.services.environment.ParameterConfigurer;
import de.iip_ecosphere.platform.services.environment.ServiceKind;
import de.iip_ecosphere.platform.services.environment.YamlService;
import iip.datatypes.RoutingCommand;
import iip.datatypes.RoutingCommandImpl;
import iip.interfaces.RoutingSinkInterface;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class RoutingSinkImpl
extends DefaultServiceImpl
implements RoutingSinkInterface {
    private List<DataIngestor<RoutingCommand>> routingCommandIngestors = new ArrayList<DataIngestor<RoutingCommand>>();
    private Map<String, ParameterConfigurer<?>> paramConfigurers = new HashMap();

    protected RoutingSinkImpl(ServiceKind kind) {
        super(kind);
        this.registerParameterConfigurers();
    }

    protected RoutingSinkImpl(String serviceId, ServiceKind kind) {
        super(serviceId, kind);
        this.registerParameterConfigurers();
    }

    protected RoutingSinkImpl(YamlService yaml) {
        super(yaml);
        this.registerParameterConfigurers();
    }

    protected RoutingSinkImpl(String serviceId, InputStream ymlFile) {
        super(serviceId, ymlFile);
        this.registerParameterConfigurers();
    }

    public ParameterConfigurer<?> getParameterConfigurer(String paramName) {
        return this.paramConfigurers.get(paramName);
    }

    public Set<String> getParameterNames() {
        return this.paramConfigurers.keySet();
    }

    protected void registerParameterConfigurers() {
    }

    @Override
    public void attachRoutingCommandIngestor(DataIngestor<RoutingCommand> ingestor) {
        if (ingestor != null) {
            this.routingCommandIngestors.add(ingestor);
        }
    }

    protected boolean hasRoutingCommandIngestor() {
        return this.routingCommandIngestors.size() > 0;
    }

    protected int hasRoutingCommandIngestorCount() {
        return this.routingCommandIngestors.size();
    }

    protected void ingestRoutingCommand(RoutingCommand data) {
        for (int i = 0; i < this.routingCommandIngestors.size(); ++i) {
            this.routingCommandIngestors.get(i).ingest((Object)data);
        }
    }

    public RoutingCommand createRoutingCommand() {
        return (RoutingCommand)this.createType(RoutingCommand.class, () -> new RoutingCommandImpl());
    }
}

