package iip.datatypes;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

import de.iip_ecosphere.platform.support.StringUtils;
import de.iip_ecosphere.platform.support.iip_aas.ConfiguredName;

import iip.datatypes.RoutingTestData;

/**
 * Implementation of the application data type RoutingTestData.
 * Generated by: EASy-Producer.
 */
@ConfiguredName("RoutingTestData")
public class RoutingTestDataImpl implements RoutingTestData {

    @JsonProperty("serNr")
    @ConfiguredName("serNr")
    private int serNr;
    @JsonProperty("stringField")
    @ConfiguredName("stringField")
    private String stringField;

    /**
     * Default constructor. Fields are pre-allocated with default Java values.
     */
    public RoutingTestDataImpl() {
    }

    /**
     * Copy constructor.
     *
     * @param from the instance to copy the values from
     */
    public RoutingTestDataImpl(RoutingTestData from) {
        this.serNr = from.getSerNr();
        this.stringField = from.getStringField();
    }

    @Override
    @JsonIgnore
    public int getSerNr() {
        return serNr;
    }

    @Override
    @JsonIgnore
    public void setSerNr(int value) {
        this.serNr = value;
    }

    @Override
    @JsonIgnore
    public String getStringField() {
        return stringField;
    }

    @Override
    @JsonIgnore
    public void setStringField(String value) {
        this.stringField = value;
    }

    @Override
    public int hashCode() {
        int hc = 0;
        hc += Integer.hashCode(getSerNr());
        hc += getStringField() != null ? getStringField().hashCode() : 0;
        return hc;
    }

    @Override
    public boolean equals(Object other) {
        boolean eq;
        if (other instanceof RoutingTestData) {
            RoutingTestData oth = (RoutingTestData) other;
            eq = true;
            eq &= getSerNr() == oth.getSerNr();
            eq &= getStringField() != null ? getStringField().equals(oth.getStringField()) : true;
        } else {
            eq = false;
        }
        return eq;
    }

    @Override
    public String toString() {
        return StringUtils.toStringShortStyle(this);
    }

}
