package iip.impl;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import de.iip_ecosphere.platform.services.environment.DataIngestor;
import de.iip_ecosphere.platform.services.environment.DefaultServiceImpl;
import de.iip_ecosphere.platform.services.environment.ParameterConfigurer;
import de.iip_ecosphere.platform.services.environment.ServiceKind;
import de.iip_ecosphere.platform.services.environment.YamlService;

import iip.datatypes.RoutingTestData;
import iip.datatypes.RoutingTestDataImpl;
import iip.interfaces.RoutingProcessorInterface;

/**
 * IIP-Ecosphere supporting service implementation for 'RoutingProcessor'.
 * Generated by: EASy-Producer.
 */
public abstract class RoutingProcessorImpl extends DefaultServiceImpl implements RoutingProcessorInterface {

    private List<DataIngestor<RoutingTestData>> routingTestDataIngestors = new ArrayList<>();
    private Map<String, ParameterConfigurer<?>> paramConfigurers = new HashMap<>();

    /**
     * Fallback constructor setting most fields to "empty" default values.
     *
     * @param kind the service kind
     */
    protected RoutingProcessorImpl(ServiceKind kind) {
        super(kind);
        registerParameterConfigurers();
    }

    /**
     * Fallback constructor setting most fields to "empty" default values.
     *
     * @param serviceId the id of the service
     * @param kind the service kind
     */
    protected RoutingProcessorImpl(String serviceId, ServiceKind kind) {
        super(serviceId, kind);
        registerParameterConfigurers();
    }

    /**
     * Creates a service instance from YAML information.
     *
     * @param yaml the service information as read from YAML
     */
    protected RoutingProcessorImpl(YamlService yaml) {
        super(yaml);
        registerParameterConfigurers();
    }

    /**
     * Creates a service instance from a service id and a YAML artifact.
     *
     * @param serviceId the id of the service
     * @param ymlFile the YML file containing the YAML artifact with the service descriptor
     */
    protected RoutingProcessorImpl(String serviceId, InputStream ymlFile) {
        super(serviceId, ymlFile);
        registerParameterConfigurers();
    }

    @Override
    public ParameterConfigurer<?> getParameterConfigurer(String paramName) {
        return paramConfigurers.get(paramName);
    }

    @Override
    public Set<String> getParameterNames() {
        return paramConfigurers.keySet();
    }

    /**
     * Registers the configurers.
     */
    protected void registerParameterConfigurers() {
    }

    @Override
    public void attachRoutingTestDataIngestor(DataIngestor<RoutingTestData> ingestor) {
        if (ingestor != null) {
            routingTestDataIngestors.add(ingestor);
        }
    }

    /**
     * Returns whether there are registered RoutingTestData ingestors.
     *
     * @return {@code true} if there are RoutingTestData ingestors, {@code false} else
     */
    protected boolean hasRoutingTestDataIngestor() {
        return routingTestDataIngestors.size() > 0;
    }

    /**
     * Returns the number of registered RoutingTestData ingestors.
     *
     * @return the number of RoutingTestData ingestors
     */
    protected int hasRoutingTestDataIngestorCount() {
        return routingTestDataIngestors.size();
    }

    /**
     * Sends {@code data} to all registered RoutingTestData ingestors.
     *
     * @param data the data to be sent
     */
    protected void ingestRoutingTestData(RoutingTestData data) {
        for (int i = 0; i < routingTestDataIngestors.size(); i++) {
            routingTestDataIngestors.get(i)
                .ingest(data);
        }
    }

    /**
     * Creates an actual instance of the output type RoutingTestData.
     */
    public RoutingTestData createRoutingTestData() {
        return createType(RoutingTestData.class, () -> new RoutingTestDataImpl());
    }

}
