package iip.interfaces;

import de.iip_ecosphere.platform.services.environment.DataIngestor;
import de.iip_ecosphere.platform.services.environment.Service;

import iip.datatypes.RoutingCommand;
import iip.datatypes.RoutingTestData;

/**
 * IIP-Ecosphere service interface for 'RoutingSink'.
 * Generated by: EASy-Producer.
 */
public interface RoutingSinkInterface extends Service {

    public static final String SERVICE_ID = "RoutingSink";

    /**
     * Processes a data item of type "RoutingTestData" asynchronously. Use the respective ingestor for the return type to
     * pass back the result of processing.
     *
     * @param data the data item to be processed
     */
    public void processRoutingTestData(RoutingTestData data);

    /**
     * Attaches a return value ingestor for asynchronous processing.
     *
     * @param ingestor the ingestor instance
     */
    public void attachRoutingCommandIngestor(DataIngestor<RoutingCommand> ingestor);

}
