package iip.serializers;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;

import de.iip_ecosphere.platform.support.json.JsonUtils;
import de.iip_ecosphere.platform.transport.serialization.Serializer;

import iip.datatypes.*;

/**
 * JSON transport serializer for RoutingCommand.
 * Generated by: EASy-Producer.
 */
public class RoutingCommandSerializer implements Serializer<RoutingCommand> {

    private static final ObjectMapper MAPPER = new ObjectMapper();

    static {
        JsonUtils.handleIipDataClasses(MAPPER);
    }

    @Override
    public RoutingCommand from(byte[] data) throws IOException {
        try {
            return MAPPER.readValue(data, RoutingCommandImpl.class);
        } catch (JsonProcessingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public byte[] to(RoutingCommand source) throws IOException {
        try {
            return MAPPER.writeValueAsBytes(source);
        } catch (JsonProcessingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public RoutingCommand clone(RoutingCommand origin) throws IOException {
        return new RoutingCommandImpl(origin);
    }

    @Override
    public Class<RoutingCommand> getType() {
        return RoutingCommand.class;
    }

}
