package iip.serializers;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;

import de.iip_ecosphere.platform.support.json.JsonUtils;
import de.iip_ecosphere.platform.transport.serialization.Serializer;

import iip.datatypes.*;

/**
 * JSON transport serializer for RoutingConnOut.
 * Generated by: EASy-Producer.
 */
public class RoutingConnOutSerializer implements Serializer<RoutingConnOut> {

    private static final ObjectMapper MAPPER = new ObjectMapper();

    static {
        JsonUtils.handleIipDataClasses(MAPPER);
    }

    @Override
    public RoutingConnOut from(byte[] data) throws IOException {
        try {
            return MAPPER.readValue(data, RoutingConnOutImpl.class);
        } catch (JsonProcessingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public byte[] to(RoutingConnOut source) throws IOException {
        try {
            return MAPPER.writeValueAsBytes(source);
        } catch (JsonProcessingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public RoutingConnOut clone(RoutingConnOut origin) throws IOException {
        return new RoutingConnOutImpl(origin);
    }

    @Override
    public Class<RoutingConnOut> getType() {
        return RoutingConnOut.class;
    }

}
