package iip.serializers;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;

import de.iip_ecosphere.platform.support.json.JsonUtils;
import de.iip_ecosphere.platform.transport.serialization.Serializer;

import iip.datatypes.*;

/**
 * JSON transport serializer for RoutingCommand.
 * Generated by: EASy-Producer.
 */
public class RoutingCommandImplSerializer implements Serializer<RoutingCommandImpl> {

    private static final ObjectMapper MAPPER = new ObjectMapper();

    static {
        JsonUtils.handleIipDataClasses(MAPPER);
    }

    @Override
    public RoutingCommandImpl from(byte[] data) throws IOException {
        try {
            return MAPPER.readValue(data, RoutingCommandImpl.class);
        } catch (JsonProcessingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public byte[] to(RoutingCommandImpl source) throws IOException {
        try {
            return MAPPER.writeValueAsBytes(source);
        } catch (JsonProcessingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public RoutingCommandImpl clone(RoutingCommandImpl origin) throws IOException {
        return new RoutingCommandImpl(origin);
    }

    @Override
    public Class<RoutingCommandImpl> getType() {
        return RoutingCommandImpl.class;
    }

}
