package iip.serializers;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;

import de.iip_ecosphere.platform.support.json.JsonUtils;
import de.iip_ecosphere.platform.transport.serialization.Serializer;

import iip.datatypes.*;

/**
 * JSON transport serializer for RoutingConnIn.
 * Generated by: EASy-Producer.
 */
public class RoutingConnInSerializer implements Serializer<RoutingConnIn> {

    private static final ObjectMapper MAPPER = new ObjectMapper();

    static {
        JsonUtils.handleIipDataClasses(MAPPER);
    }

    @Override
    public RoutingConnIn from(byte[] data) throws IOException {
        try {
            return MAPPER.readValue(data, RoutingConnInImpl.class);
        } catch (JsonProcessingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public byte[] to(RoutingConnIn source) throws IOException {
        try {
            return MAPPER.writeValueAsBytes(source);
        } catch (JsonProcessingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public RoutingConnIn clone(RoutingConnIn origin) throws IOException {
        return new RoutingConnInImpl(origin);
    }

    @Override
    public Class<RoutingConnIn> getType() {
        return RoutingConnIn.class;
    }

}
