package iip.datatypes;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

import de.iip_ecosphere.platform.support.StringUtils;
import de.iip_ecosphere.platform.support.iip_aas.ConfiguredName;

import iip.datatypes.MipMqttInput;

/**
 * Implementation of the application data type MipMqttInput.
 * Generated by: EASy-Producer.
 */
@ConfiguredName("MipMqttInput")
public class MipMqttInputImpl implements MipMqttInput {

    @JsonProperty("mipcontext")
    @ConfiguredName("mipcontext")
    private String mipcontext;
    @JsonProperty("mipdate")
    @ConfiguredName("mipdate")
    private String mipdate;
    @JsonProperty("mipto")
    @ConfiguredName("mipto")
    private String mipto;
    @JsonProperty("mipfrom")
    @ConfiguredName("mipfrom")
    private String mipfrom;
    @JsonProperty("mipcommand")
    @ConfiguredName("mipcommand")
    private String mipcommand;
    @JsonProperty("mipbitstream_ai_clock")
    @ConfiguredName("mipbitstream_ai_clock")
    private String mipbitstream_ai_clock;
    @JsonProperty("mipbitstream_ai_data1")
    @ConfiguredName("mipbitstream_ai_data1")
    private String mipbitstream_ai_data1;
    @JsonProperty("mipbitstream_ai_data2")
    @ConfiguredName("mipbitstream_ai_data2")
    private String mipbitstream_ai_data2;
    @JsonProperty("mipreader")
    @ConfiguredName("mipreader")
    private String mipreader;

    /**
     * Default constructor. Fields are pre-allocated with default Java values.
     */
    public MipMqttInputImpl() {
    }

    /**
     * Copy constructor.
     *
     * @param from the instance to copy the values from
     */
    public MipMqttInputImpl(MipMqttInput from) {
        this.mipcontext = from.getMipcontext();
        this.mipdate = from.getMipdate();
        this.mipto = from.getMipto();
        this.mipfrom = from.getMipfrom();
        this.mipcommand = from.getMipcommand();
        this.mipbitstream_ai_clock = from.getMipbitstream_ai_clock();
        this.mipbitstream_ai_data1 = from.getMipbitstream_ai_data1();
        this.mipbitstream_ai_data2 = from.getMipbitstream_ai_data2();
        this.mipreader = from.getMipreader();
    }

    @Override
    @JsonIgnore
    public String getMipcontext() {
        return mipcontext;
    }

    @Override
    @JsonIgnore
    public void setMipcontext(String value) {
        this.mipcontext = value;
    }

    @Override
    @JsonIgnore
    public String getMipdate() {
        return mipdate;
    }

    @Override
    @JsonIgnore
    public void setMipdate(String value) {
        this.mipdate = value;
    }

    @Override
    @JsonIgnore
    public String getMipto() {
        return mipto;
    }

    @Override
    @JsonIgnore
    public void setMipto(String value) {
        this.mipto = value;
    }

    @Override
    @JsonIgnore
    public String getMipfrom() {
        return mipfrom;
    }

    @Override
    @JsonIgnore
    public void setMipfrom(String value) {
        this.mipfrom = value;
    }

    @Override
    @JsonIgnore
    public String getMipcommand() {
        return mipcommand;
    }

    @Override
    @JsonIgnore
    public void setMipcommand(String value) {
        this.mipcommand = value;
    }

    @Override
    @JsonIgnore
    public String getMipbitstream_ai_clock() {
        return mipbitstream_ai_clock;
    }

    @Override
    @JsonIgnore
    public void setMipbitstream_ai_clock(String value) {
        this.mipbitstream_ai_clock = value;
    }

    @Override
    @JsonIgnore
    public String getMipbitstream_ai_data1() {
        return mipbitstream_ai_data1;
    }

    @Override
    @JsonIgnore
    public void setMipbitstream_ai_data1(String value) {
        this.mipbitstream_ai_data1 = value;
    }

    @Override
    @JsonIgnore
    public String getMipbitstream_ai_data2() {
        return mipbitstream_ai_data2;
    }

    @Override
    @JsonIgnore
    public void setMipbitstream_ai_data2(String value) {
        this.mipbitstream_ai_data2 = value;
    }

    @Override
    @JsonIgnore
    public String getMipreader() {
        return mipreader;
    }

    @Override
    @JsonIgnore
    public void setMipreader(String value) {
        this.mipreader = value;
    }

    @Override
    public int hashCode() {
        int hc = 0;
        hc += getMipcontext() != null ? getMipcontext().hashCode() : 0;
        hc += getMipdate() != null ? getMipdate().hashCode() : 0;
        hc += getMipto() != null ? getMipto().hashCode() : 0;
        hc += getMipfrom() != null ? getMipfrom().hashCode() : 0;
        hc += getMipcommand() != null ? getMipcommand().hashCode() : 0;
        hc += getMipbitstream_ai_clock() != null ? getMipbitstream_ai_clock().hashCode() : 0;
        hc += getMipbitstream_ai_data1() != null ? getMipbitstream_ai_data1().hashCode() : 0;
        hc += getMipbitstream_ai_data2() != null ? getMipbitstream_ai_data2().hashCode() : 0;
        hc += getMipreader() != null ? getMipreader().hashCode() : 0;
        return hc;
    }

    @Override
    public boolean equals(Object other) {
        boolean eq;
        if (other instanceof MipMqttInput) {
            MipMqttInput oth = (MipMqttInput) other;
            eq = true;
            eq &= getMipcontext() != null ? getMipcontext().equals(oth.getMipcontext()) : true;
            eq &= getMipdate() != null ? getMipdate().equals(oth.getMipdate()) : true;
            eq &= getMipto() != null ? getMipto().equals(oth.getMipto()) : true;
            eq &= getMipfrom() != null ? getMipfrom().equals(oth.getMipfrom()) : true;
            eq &= getMipcommand() != null ? getMipcommand().equals(oth.getMipcommand()) : true;
            eq &= getMipbitstream_ai_clock() != null ? getMipbitstream_ai_clock().equals(oth.getMipbitstream_ai_clock())
                : true;
            eq &= getMipbitstream_ai_data1() != null ? getMipbitstream_ai_data1().equals(oth.getMipbitstream_ai_data1())
                : true;
            eq &= getMipbitstream_ai_data2() != null ? getMipbitstream_ai_data2().equals(oth.getMipbitstream_ai_data2())
                : true;
            eq &= getMipreader() != null ? getMipreader().equals(oth.getMipreader()) : true;
        } else {
            eq = false;
        }
        return eq;
    }

    @Override
    public String toString() {
        return StringUtils.toStringShortStyle(this);
    }

}
