package iip.datatypes;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

import de.iip_ecosphere.platform.support.StringUtils;
import de.iip_ecosphere.platform.support.iip_aas.ConfiguredName;

import iip.datatypes.RoutingCommand;

/**
 * Implementation of the application data type RoutingCommand.
 * Generated by: EASy-Producer.
 */
@ConfiguredName("RoutingCommand")
public class RoutingCommandImpl implements RoutingCommand {

    @JsonProperty("cmd")
    @ConfiguredName("cmd")
    private String cmd;

    /**
     * Default constructor. Fields are pre-allocated with default Java values.
     */
    public RoutingCommandImpl() {
    }

    /**
     * Copy constructor.
     *
     * @param from the instance to copy the values from
     */
    public RoutingCommandImpl(RoutingCommand from) {
        this.cmd = from.getCmd();
    }

    @Override
    @JsonIgnore
    public String getCmd() {
        return cmd;
    }

    @Override
    @JsonIgnore
    public void setCmd(String value) {
        this.cmd = value;
    }

    @Override
    public int hashCode() {
        int hc = 0;
        hc += getCmd() != null ? getCmd().hashCode() : 0;
        return hc;
    }

    @Override
    public boolean equals(Object other) {
        boolean eq;
        if (other instanceof RoutingCommand) {
            RoutingCommand oth = (RoutingCommand) other;
            eq = true;
            eq &= getCmd() != null ? getCmd().equals(oth.getCmd()) : true;
        } else {
            eq = false;
        }
        return eq;
    }

    @Override
    public String toString() {
        return StringUtils.toStringShortStyle(this);
    }

}
