package iip.datatypes;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

import de.iip_ecosphere.platform.support.StringUtils;
import de.iip_ecosphere.platform.support.iip_aas.ConfiguredName;

import iip.datatypes.RoutingConnOut;

/**
 * Implementation of the application data type RoutingConnOut.
 * Generated by: EASy-Producer.
 */
@ConfiguredName("RoutingConnOut")
public class RoutingConnOutImpl implements RoutingConnOut {

    @JsonProperty("serNr")
    @ConfiguredName("serNr")
    private int serNr;
    @JsonProperty("data")
    @ConfiguredName("data")
    private String data;

    /**
     * Default constructor. Fields are pre-allocated with default Java values.
     */
    public RoutingConnOutImpl() {
    }

    /**
     * Copy constructor.
     *
     * @param from the instance to copy the values from
     */
    public RoutingConnOutImpl(RoutingConnOut from) {
        this.serNr = from.getSerNr();
        this.data = from.getData();
    }

    @Override
    @JsonIgnore
    public int getSerNr() {
        return serNr;
    }

    @Override
    @JsonIgnore
    public void setSerNr(int value) {
        this.serNr = value;
    }

    @Override
    @JsonIgnore
    public String getData() {
        return data;
    }

    @Override
    @JsonIgnore
    public void setData(String value) {
        this.data = value;
    }

    @Override
    public int hashCode() {
        int hc = 0;
        hc += Integer.hashCode(getSerNr());
        hc += getData() != null ? getData().hashCode() : 0;
        return hc;
    }

    @Override
    public boolean equals(Object other) {
        boolean eq;
        if (other instanceof RoutingConnOut) {
            RoutingConnOut oth = (RoutingConnOut) other;
            eq = true;
            eq &= getSerNr() == oth.getSerNr();
            eq &= getData() != null ? getData().equals(oth.getData()) : true;
        } else {
            eq = false;
        }
        return eq;
    }

    @Override
    public String toString() {
        return StringUtils.toStringShortStyle(this);
    }

}
