package iip.serializers;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;

import de.iip_ecosphere.platform.support.json.JsonUtils;
import de.iip_ecosphere.platform.transport.serialization.Serializer;

import iip.datatypes.*;

/**
 * JSON transport serializer for RoutingConnIn.
 * Generated by: EASy-Producer.
 */
public class RoutingConnInImplSerializer implements Serializer<RoutingConnInImpl> {

    private static final ObjectMapper MAPPER = new ObjectMapper();

    static {
        JsonUtils.handleIipDataClasses(MAPPER);
    }

    @Override
    public RoutingConnInImpl from(byte[] data) throws IOException {
        try {
            return MAPPER.readValue(data, RoutingConnInImpl.class);
        } catch (JsonProcessingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public byte[] to(RoutingConnInImpl source) throws IOException {
        try {
            return MAPPER.writeValueAsBytes(source);
        } catch (JsonProcessingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public RoutingConnInImpl clone(RoutingConnInImpl origin) throws IOException {
        return new RoutingConnInImpl(origin);
    }

    @Override
    public Class<RoutingConnInImpl> getType() {
        return RoutingConnInImpl.class;
    }

}
