package iip.serializers;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;

import de.iip_ecosphere.platform.support.json.JsonUtils;
import de.iip_ecosphere.platform.transport.serialization.Serializer;

import iip.datatypes.*;

/**
 * JSON transport serializer for RoutingTestData.
 * Generated by: EASy-Producer.
 */
public class RoutingTestDataImplSerializer implements Serializer<RoutingTestDataImpl> {

    private static final ObjectMapper MAPPER = new ObjectMapper();

    static {
        JsonUtils.handleIipDataClasses(MAPPER);
    }

    @Override
    public RoutingTestDataImpl from(byte[] data) throws IOException {
        try {
            return MAPPER.readValue(data, RoutingTestDataImpl.class);
        } catch (JsonProcessingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public byte[] to(RoutingTestDataImpl source) throws IOException {
        try {
            return MAPPER.writeValueAsBytes(source);
        } catch (JsonProcessingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public RoutingTestDataImpl clone(RoutingTestDataImpl origin) throws IOException {
        return new RoutingTestDataImpl(origin);
    }

    @Override
    public Class<RoutingTestDataImpl> getType() {
        return RoutingTestDataImpl.class;
    }

}
