package iip.serializers;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;

import de.iip_ecosphere.platform.support.json.JsonUtils;
import de.iip_ecosphere.platform.transport.serialization.Serializer;

import iip.datatypes.*;

/**
 * JSON transport serializer for RoutingTestData.
 * Generated by: EASy-Producer.
 */
public class RoutingTestDataSerializer implements Serializer<RoutingTestData> {

    private static final ObjectMapper MAPPER = new ObjectMapper();

    static {
        JsonUtils.handleIipDataClasses(MAPPER);
    }

    @Override
    public RoutingTestData from(byte[] data) throws IOException {
        try {
            return MAPPER.readValue(data, RoutingTestDataImpl.class);
        } catch (JsonProcessingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public byte[] to(RoutingTestData source) throws IOException {
        try {
            return MAPPER.writeValueAsBytes(source);
        } catch (JsonProcessingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public RoutingTestData clone(RoutingTestData origin) throws IOException {
        return new RoutingTestDataImpl(origin);
    }

    @Override
    public Class<RoutingTestData> getType() {
        return RoutingTestData.class;
    }

}
