/*
 * Decompiled with CFR 0.152.
 */
package iip.impl;

import de.iip_ecosphere.platform.services.environment.DataIngestor;
import de.iip_ecosphere.platform.services.environment.DefaultServiceImpl;
import de.iip_ecosphere.platform.services.environment.ParameterConfigurer;
import de.iip_ecosphere.platform.services.environment.ServiceKind;
import de.iip_ecosphere.platform.services.environment.YamlService;
import iip.datatypes.RoutingTestData;
import iip.datatypes.RoutingTestDataImpl;
import iip.interfaces.RoutingProcessorInterface;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class RoutingProcessorImpl
extends DefaultServiceImpl
implements RoutingProcessorInterface {
    private List<DataIngestor<RoutingTestData>> routingTestDataIngestors = new ArrayList<DataIngestor<RoutingTestData>>();
    private Map<String, ParameterConfigurer<?>> paramConfigurers = new HashMap();

    protected RoutingProcessorImpl(ServiceKind kind) {
        super(kind);
        this.registerParameterConfigurers();
    }

    protected RoutingProcessorImpl(String serviceId, ServiceKind kind) {
        super(serviceId, kind);
        this.registerParameterConfigurers();
    }

    protected RoutingProcessorImpl(YamlService yaml) {
        super(yaml);
        this.registerParameterConfigurers();
    }

    protected RoutingProcessorImpl(String serviceId, InputStream ymlFile) {
        super(serviceId, ymlFile);
        this.registerParameterConfigurers();
    }

    public ParameterConfigurer<?> getParameterConfigurer(String paramName) {
        return this.paramConfigurers.get(paramName);
    }

    public Set<String> getParameterNames() {
        return this.paramConfigurers.keySet();
    }

    protected void registerParameterConfigurers() {
    }

    @Override
    public void attachRoutingTestDataIngestor(DataIngestor<RoutingTestData> ingestor) {
        if (ingestor != null) {
            this.routingTestDataIngestors.add(ingestor);
        }
    }

    protected boolean hasRoutingTestDataIngestor() {
        return this.routingTestDataIngestors.size() > 0;
    }

    protected int hasRoutingTestDataIngestorCount() {
        return this.routingTestDataIngestors.size();
    }

    protected void ingestRoutingTestData(RoutingTestData data) {
        for (int i = 0; i < this.routingTestDataIngestors.size(); ++i) {
            this.routingTestDataIngestors.get(i).ingest((Object)data);
        }
    }

    public RoutingTestData createRoutingTestData() {
        return (RoutingTestData)this.createType(RoutingTestData.class, () -> new RoutingTestDataImpl());
    }
}

