package iip.serializers;

import java.io.IOException;

import de.iip_ecosphere.platform.support.json.Json;
import de.iip_ecosphere.platform.transport.serialization.Serializer;

import iip.datatypes.*;

/**
 * JSON transport serializer for RoutingTestData.
 * Generated by: EASy-Producer.
 */
public class RoutingTestDataImplSerializer implements Serializer<RoutingTestDataImpl> {

    private static final Json MAPPER = Json.createInstance4All();

    static {
        MAPPER.handleIipDataClasses();
    }

    @Override
    public RoutingTestDataImpl from(byte[] data) throws IOException {
        return MAPPER.readValue(data, RoutingTestDataImpl.class);
    }

    @Override
    public byte[] to(RoutingTestDataImpl source) throws IOException {
        return MAPPER.writeValueAsBytes(source);
    }

    @Override
    public RoutingTestDataImpl clone(RoutingTestDataImpl origin) throws IOException {
        return new RoutingTestDataImpl(origin);
    }

    @Override
    public Class<RoutingTestDataImpl> getType() {
        return RoutingTestDataImpl.class;
    }

}
