package iip.serializers;

import java.io.IOException;

import de.iip_ecosphere.platform.support.json.Json;
import de.iip_ecosphere.platform.transport.serialization.Serializer;

import iip.datatypes.*;

/**
 * JSON transport serializer for RoutingConnOut.
 * Generated by: EASy-Producer.
 */
public class RoutingConnOutSerializer implements Serializer<RoutingConnOut> {

    private static final Json MAPPER = Json.createInstance4All();

    static {
        MAPPER.handleIipDataClasses();
    }

    @Override
    public RoutingConnOut from(byte[] data) throws IOException {
        return MAPPER.readValue(data, RoutingConnOutImpl.class);
    }

    @Override
    public byte[] to(RoutingConnOut source) throws IOException {
        return MAPPER.writeValueAsBytes(source);
    }

    @Override
    public RoutingConnOut clone(RoutingConnOut origin) throws IOException {
        return new RoutingConnOutImpl(origin);
    }

    @Override
    public Class<RoutingConnOut> getType() {
        return RoutingConnOut.class;
    }

}
