package iip.serializers;

import java.io.IOException;

import de.iip_ecosphere.platform.support.json.Json;
import de.iip_ecosphere.platform.transport.serialization.Serializer;

import iip.datatypes.*;

/**
 * JSON transport serializer for RoutingTestData.
 * Generated by: EASy-Producer.
 */
public class RoutingTestDataSerializer implements Serializer<RoutingTestData> {

    private static final Json MAPPER = Json.createInstance4All();

    static {
        MAPPER.handleIipDataClasses();
    }

    @Override
    public RoutingTestData from(byte[] data) throws IOException {
        return MAPPER.readValue(data, RoutingTestDataImpl.class);
    }

    @Override
    public byte[] to(RoutingTestData source) throws IOException {
        return MAPPER.writeValueAsBytes(source);
    }

    @Override
    public RoutingTestData clone(RoutingTestData origin) throws IOException {
        return new RoutingTestDataImpl(origin);
    }

    @Override
    public Class<RoutingTestData> getType() {
        return RoutingTestData.class;
    }

}
