package iip.serializers;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;

import de.iip_ecosphere.platform.support.json.JsonUtils;
import de.iip_ecosphere.platform.transport.serialization.Serializer;

import iip.datatypes.*;

/**
 * JSON transport serializer for Rec1.
 * Generated by: EASy-Producer.
 */
public class Rec1ImplSerializer implements Serializer<Rec1Impl> {

    private static final ObjectMapper MAPPER = new ObjectMapper();

    static {
        JsonUtils.handleIipDataClasses(MAPPER);
    }

    @Override
    public Rec1Impl from(byte[] data) throws IOException {
        try {
            return MAPPER.readValue(data, Rec1Impl.class);
        } catch (JsonProcessingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public byte[] to(Rec1Impl source) throws IOException {
        try {
            return MAPPER.writeValueAsBytes(source);
        } catch (JsonProcessingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public Rec1Impl clone(Rec1Impl origin) throws IOException {
        return new Rec1Impl(origin);
    }

    @Override
    public Class<Rec1Impl> getType() {
        return Rec1Impl.class;
    }

}
