package iip.serializers;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;

import de.iip_ecosphere.platform.support.json.JsonUtils;
import de.iip_ecosphere.platform.transport.serialization.Serializer;

import iip.datatypes.*;

/**
 * JSON transport serializer for Feedback.
 * Generated by: EASy-Producer.
 */
public class FeedbackImplSerializer implements Serializer<FeedbackImpl> {

    private static final ObjectMapper MAPPER = new ObjectMapper();

    static {
        JsonUtils.handleIipDataClasses(MAPPER);
    }

    @Override
    public FeedbackImpl from(byte[] data) throws IOException {
        try {
            return MAPPER.readValue(data, FeedbackImpl.class);
        } catch (JsonProcessingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public byte[] to(FeedbackImpl source) throws IOException {
        try {
            return MAPPER.writeValueAsBytes(source);
        } catch (JsonProcessingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public FeedbackImpl clone(FeedbackImpl origin) throws IOException {
        return new FeedbackImpl(origin);
    }

    @Override
    public Class<FeedbackImpl> getType() {
        return FeedbackImpl.class;
    }

}
