package iip.interfaces;

import de.iip_ecosphere.platform.services.environment.DataIngestor;
import de.iip_ecosphere.platform.services.environment.Service;

import iip.datatypes.Feedback;
import iip.datatypes.Rec1;

/**
 * IIP-Ecosphere service interface for 'Simple Data Source'.
 * Generated by: EASy-Producer.
 */
public interface SimpleDataSourceInterface extends Service {

    public static final String SERVICE_ID = "SimpleSource";

    /**
     * Processes a data item of type "Feedback" asynchronously. Use the respective ingestor for the return type to pass
     * back the result of processing.
     *
     * @param data the data item to be processed
     */
    public void processFeedback(Feedback data);

    /**
     * Attaches a return value ingestor for asynchronous processing.
     *
     * @param ingestor the ingestor instance
     */
    public void attachRec1Ingestor(DataIngestor<Rec1> ingestor);

}
