package iip.serializers;

import java.io.IOException;

import de.iip_ecosphere.platform.support.json.Json;
import de.iip_ecosphere.platform.transport.serialization.Serializer;

import iip.datatypes.*;

/**
 * JSON transport serializer for Rec1.
 * Generated by: EASy-Producer.
 */
public class Rec1Serializer implements Serializer<Rec1> {

    private static final Json MAPPER = Json.createInstance4All();

    static {
        MAPPER.handleIipDataClasses();
    }

    @Override
    public Rec1 from(byte[] data) throws IOException {
        return MAPPER.readValue(data, Rec1Impl.class);
    }

    @Override
    public byte[] to(Rec1 source) throws IOException {
        return MAPPER.writeValueAsBytes(source);
    }

    @Override
    public Rec1 clone(Rec1 origin) throws IOException {
        return new Rec1Impl(origin);
    }

    @Override
    public Class<Rec1> getType() {
        return Rec1.class;
    }

}
