package iip.serializers;

import java.io.IOException;

import de.iip_ecosphere.platform.support.json.Json;
import de.iip_ecosphere.platform.transport.serialization.Serializer;

import iip.datatypes.*;

/**
 * JSON transport serializer for SubmodelElementList.
 * Generated by: EASy-Producer.
 */
public class SubmodelElementListSerializer implements Serializer<SubmodelElementList> {

    private static final Json MAPPER = Json.createInstance4All();

    static {
        MAPPER.handleIipDataClasses();
    }

    @Override
    public SubmodelElementList from(byte[] data) throws IOException {
        return MAPPER.readValue(data, SubmodelElementListImpl.class);
    }

    @Override
    public byte[] to(SubmodelElementList source) throws IOException {
        return MAPPER.writeValueAsBytes(source);
    }

    @Override
    public SubmodelElementList clone(SubmodelElementList origin) throws IOException {
        return new SubmodelElementListImpl(origin);
    }

    @Override
    public Class<SubmodelElementList> getType() {
        return SubmodelElementList.class;
    }

}
