package iip.serializers;

import java.io.IOException;

import de.iip_ecosphere.platform.support.json.Json;
import de.iip_ecosphere.platform.transport.serialization.Serializer;

import iip.datatypes.*;

/**
 * JSON transport serializer for Feedback.
 * Generated by: EASy-Producer.
 */
public class FeedbackSerializer implements Serializer<Feedback> {

    private static final Json MAPPER = Json.createInstance4All();

    static {
        MAPPER.handleIipDataClasses();
    }

    @Override
    public Feedback from(byte[] data) throws IOException {
        return MAPPER.readValue(data, FeedbackImpl.class);
    }

    @Override
    public byte[] to(Feedback source) throws IOException {
        return MAPPER.writeValueAsBytes(source);
    }

    @Override
    public Feedback clone(Feedback origin) throws IOException {
        return new FeedbackImpl(origin);
    }

    @Override
    public Class<Feedback> getType() {
        return Feedback.class;
    }

}
