package iip.serializers;

import java.io.IOException;

import de.iip_ecosphere.platform.support.json.Json;
import de.iip_ecosphere.platform.transport.serialization.Serializer;

import iip.datatypes.*;

/**
 * JSON transport serializer for MipMqttInput.
 * Generated by: EASy-Producer.
 */
public class MipMqttInputImplSerializer implements Serializer<MipMqttInputImpl> {

    private static final Json MAPPER = Json.createInstance4All();

    static {
        MAPPER.defineOptionals(MipMqttInputImpl.class, "mipfrom", "mipcommand", "mipbitstream_ai_clock", 
            "mipbitstream_ai_data1", "mipbitstream_ai_data2", "mipreader");
        MAPPER.handleIipDataClasses();
    }

    @Override
    public MipMqttInputImpl from(byte[] data) throws IOException {
        return MAPPER.readValue(data, MipMqttInputImpl.class);
    }

    @Override
    public byte[] to(MipMqttInputImpl source) throws IOException {
        return MAPPER.writeValueAsBytes(source);
    }

    @Override
    public MipMqttInputImpl clone(MipMqttInputImpl origin) throws IOException {
        return new MipMqttInputImpl(origin);
    }

    @Override
    public Class<MipMqttInputImpl> getType() {
        return MipMqttInputImpl.class;
    }

}
